% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updateTimerInput.R
\name{updateTimerInput}
\alias{updateTimerInput}
\title{updateTimerInput}
\usage{
updateTimerInput(
  session = getDefaultReactiveDomain(),
  inputId,
  step1 = list(),
  reset = list(),
  ...
)
}
\arguments{
\item{session}{session object}

\item{inputId}{id of the input object}

\item{step1}{modified values for \code{Step} button, see \code{\link[shiny:updateActionButton]{shiny::updateActionButton()}}}

\item{reset}{modified values for \code{Reset} button, see \code{\link[shiny:updateActionButton]{shiny::updateActionButton()}}}

\item{...}{modified values for \code{Speed} slider, see \code{\link[shiny:updateSliderInput]{shiny::updateSliderInput()}}}
}
\value{
nothing
}
\description{
updateTimerInput
}
\examples{
# Example requires the use of a `shiny` app (See Vignette)
# Updates the timer UI in a `shiny` app
if (interactive()) {
  library(shiny)
  library(shinyDTC)

  ui <- fluidPage(
    timerUI("timer1"),
    actionButton("update", "Update Timer UI")
  )

  server <- function(input, output, session) {
    timerServer("timer1")

    observeEvent(input$update, {
      updateTimerInput(
        session, "timer1",
        step1 = list(label = "Advance"),
        reset = list(label = "Clear"),
        min = 0, max = 100, value = 10
      )
    })
  }

  shinyApp(ui, server)
}
}
