% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resetTimer.R
\name{resetTimer}
\alias{resetTimer}
\title{resetTimer}
\usage{
resetTimer(inputId)
}
\arguments{
\item{inputId}{character: input slot}
}
\value{
nothing
}
\description{
Simulates a button press for \code{Reset}.
}
\examples{
# Example requires the use of a `shiny` app (See Vignette)
if (interactive()) {
  library(shiny)
  library(shinyDTC)
  library(shinyjs)

  ui <- fluidPage(
    useShinyjs(),
    timerUI("timer1"),
    actionButton("reset", "Trigger Reset")
  )

  server <- function(input, output, session) {
    timerServer("timer1")

    observeEvent(input$reset, {
      resetTimer("timer1")
    })
  }

  shinyApp(ui, server)
}

\dontrun{
# `resetTimer` must be used inside a `shiny` server function
# and requires `shinyjs` + a corresponding timer UI
}
}
