% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qrs.prop.fast.r
\name{.qrs.prop.fast}
\alias{.qrs.prop.fast}
\title{qrs.prop.fast}
\usage{
.qrs.prop.fast(y, x, prop, w = NULL, Q1, Q2, P = 10, family, gridtheta, m)
}
\arguments{
\item{y}{= Dependent variable (N x 1)}

\item{x}{= Regressors matrix (N x K)}

\item{prop}{= Propensity score (N x 1)}

\item{w}{= Sample weights (N x 1)}

\item{Q1}{= Number of quantiles in reduced grid}

\item{Q2}{= Number of quantiles in large grid}

\item{P}{=  Number of evaluated values of parameter with large quantile
grid}

\item{family}{= Parametric copula family}

\item{gridtheta}{= Grid of values for copula parameter (T x 1)}

\item{m}{=  Parameter to select interval of observations in top and bottom
groups}
}
\value{
beta = Estimated beta coefficients (K x Q2)

theta = Estimated copula parameter

objf_min = Value of objective function at the optimum

b1 = Estimated beta coefficients for the grid of values of the
copula parameter with the reduced quantile grid (K x Q1 x T)

objf1 = Value of objective function for the grid of values of the
copula parameter with the reduced quantile grid

gridtheta2 = Grid of values for copula parameter selected during
the first part of the algorithm (P x 1)

b2 = Estimated beta coefficients for the grid of values of the
copula parameter with large quantile grid (K x Q2 x P)

objf2 = Value of objective function for the grid of values of the
copula parameter with large quantile grid (P x 1)
}
\description{
Algorithm 3: algorithm with preprocessing and quantile grid reduction for
Quantile Regression with Selection (QRS); propensity score estimated
previously.
}
