#' Motion Sense Dataset: Measurements of user acceleration and pitch attitude collected by smartphones from 24 individuals performing four distinct activities: jogging, walking, sitting, and standing.
#'
#' This dataset includes time-series data generated by accelerometer and gyroscope sensors.
#' A total of 24 participants in a range of gender, age, weight, and height performed 4 activities in the same environment 
#' and conditions: downstairs, upstairs, walking, jogging, sitting, and standing.
#'
#' @name motion_sense_data
#' @docType data
#' @format A bivariate functional data object of class `mvmfd` with the following fields:
#' \describe{
#'   \item{user_acceleration}{Time-series data of user acceleration.}
#'   \item{pitch_attitude}{Time-series data of pitch attitude.}
#' }
#' @source The MotionSense dataset collected by https://github.com/mmalekzadeh.
#' @examples
#' \dontrun{
#' # Load the Motion Sense Dataset
#' data("motion_sense_data")
#' }
NULL